/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.create;

import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.piston.PistonExtensionPoleBlock;
import com.simibubi.create.content.equipment.goggles.GoggleOverlayRenderer;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.fluids.drain.ItemDrainBlockEntity;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.trains.entity.TrainRelocator;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import snownee.jade.addon.create.CreatePlugin;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IElementHelper;

public class GogglesProvider
implements IBlockComponentProvider {
    private static final ResourceLocation CREATE_OVERLAY_ID = new ResourceLocation("create", "goggle_info");
    private static final Set<String> REMOVE_KEYS = Set.of("create.tooltip.chute.contains", "create.tooltip.deployer.contains");
    private final Block PISTON_EXTENSION_POLE = GogglesProvider.block("piston_extension_pole");

    private static Block block(String id) {
        return (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation("create", id));
    }

    public GogglesProvider() {
        MinecraftForge.EVENT_BUS.addListener(this::hideCreateOverlay);
    }

    private void hideCreateOverlay(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay().id().equals((Object)CREATE_OVERLAY_ID) && IWailaConfig.get().getPlugin().get(CreatePlugin.GOGGLES)) {
            event.setCanceled(true);
        }
    }

    public ResourceLocation getUid() {
        return CreatePlugin.GOGGLES;
    }

    public void appendTooltip(ITooltip tooltip1, BlockAccessor accessor, IPluginConfig config) {
        boolean exceptionAdded;
        FluidTankBlockEntity tank;
        if (config.get(CreatePlugin.GOGGLES_DETAILED) && !accessor.showDetails()) {
            return;
        }
        Level world = accessor.getLevel();
        BlockPos pos = GoggleOverlayRenderer.proxiedOverlayPosition((Level)world, (BlockPos)accessor.getPosition());
        BlockEntity te = world.m_7702_(pos);
        boolean wearingGoggles = !config.get(CreatePlugin.REQUIRES_GOGGLES) || GogglesItem.isWearingGoggles((Player)accessor.getPlayer());
        boolean hasGoggleInformation = te instanceof IHaveGoggleInformation && !(te instanceof SpoutBlockEntity) && !(te instanceof ItemDrainBlockEntity) && !(te instanceof BasinBlockEntity) && (!(te instanceof FluidTankBlockEntity) || (tank = (FluidTankBlockEntity)te).getControllerBE() == null || tank.getControllerBE().boiler.isActive());
        boolean hasHoveringInformation = te instanceof IHaveHoveringInformation;
        boolean goggleAddedInformation = false;
        boolean hoverAddedInformation = false;
        ArrayList<Object> tooltip = new ArrayList<Object>();
        if (hasGoggleInformation && wearingGoggles) {
            IHaveGoggleInformation gte = (IHaveGoggleInformation)te;
            goggleAddedInformation = gte.addToGoggleTooltip(tooltip, accessor.showDetails());
        }
        if (hasHoveringInformation) {
            if (!tooltip.isEmpty()) {
                tooltip.add(Components.immutableEmpty());
            }
            IHaveHoveringInformation hte = (IHaveHoveringInformation)te;
            hoverAddedInformation = hte.addToTooltip(tooltip, accessor.showDetails());
            if (goggleAddedInformation && !hoverAddedInformation) {
                tooltip.remove(tooltip.size() - 1);
            }
        }
        if (te instanceof IDisplayAssemblyExceptions && (exceptionAdded = ((IDisplayAssemblyExceptions)te).addExceptionToTooltip(tooltip))) {
            hasHoveringInformation = true;
            hoverAddedInformation = true;
        }
        if (!hasHoveringInformation) {
            hasHoveringInformation = hoverAddedInformation = TrainRelocator.addToTooltip(tooltip, (boolean)accessor.showDetails());
        }
        if (hasGoggleInformation && !goggleAddedInformation && hasHoveringInformation && !hoverAddedInformation) {
            return;
        }
        tooltip.removeIf(c -> {
            for (Component sibling : c.m_7360_()) {
                TranslatableContents contents;
                ComponentContents patt5612$temp = sibling.m_214077_();
                if (!(patt5612$temp instanceof TranslatableContents) || !REMOVE_KEYS.contains((contents = (TranslatableContents)patt5612$temp).m_237508_())) continue;
                return true;
            }
            return false;
        });
        tooltip.replaceAll(c -> {
            LiteralContents literal;
            ComponentContents patt5809$temp = c.m_214077_();
            if (patt5809$temp instanceof LiteralContents && (literal = (LiteralContents)patt5809$temp).f_237368_().startsWith("    ")) {
                MutableComponent mutableComponent = Component.m_237113_((String)literal.f_237368_().substring(4)).m_130948_(c.m_7383_());
                c.m_7360_().forEach(arg_0 -> ((MutableComponent)mutableComponent).m_7220_(arg_0));
                return mutableComponent;
            }
            return c;
        });
        BlockState state = world.m_8055_(pos);
        if (wearingGoggles && state.m_60713_(this.PISTON_EXTENSION_POLE)) {
            Direction[] directions = Iterate.directionsInAxis((Direction.Axis)((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_)).m_122434_());
            int poles = 1;
            boolean pistonFound = false;
            for (Direction dir : directions) {
                int attachedPoles = PistonExtensionPoleBlock.PlacementHelper.get().attachedPoles(world, pos, dir);
                poles += attachedPoles;
                pistonFound |= world.m_8055_(pos.m_5484_(dir, attachedPoles + 1)).m_60734_() instanceof MechanicalPistonBlock;
            }
            if (!pistonFound) {
                return;
            }
            if (!tooltip.isEmpty()) {
                tooltip.add(Components.immutableEmpty());
            }
            tooltip.add(Lang.translateDirect((String)"gui.goggles.pole_length", (Object[])new Object[0]).m_7220_((Component)Components.literal((String)(" " + poles))));
        }
        tooltip.stream().map(c -> {
            if (c.getString().isBlank()) {
                return IElementHelper.get().spacer(3, 3);
            }
            return IElementHelper.get().text(c);
        }).forEach(arg_0 -> ((ITooltip)tooltip1).add(arg_0));
    }

    public boolean enabledByDefault() {
        return false;
    }
}

